#include <bits/stdc++.h>
using namespace std;
struct Point {
    int idx;
    long long x, y;
};
struct Edge {
    int u, v;
    long long w;
    bool operator<(const Edge &other) const {
        return w < other.w;
    }
};
struct DSU {
    vector<int> p, sz;
    DSU(int n) : p(n), sz(n,1) { iota(p.begin(), p.end(), 0); }
    int find(int x) { return p[x]==x ? x : p[x]=find(p[x]); }
    bool unite(int a, int b) {
        a = find(a); b = find(b);
        if(a==b) return false;
        if(sz[a]<sz[b]) swap(a,b);
        p[b]=a; sz[a]+=sz[b];
        return true;
    }
};
void add_edges(vector<Point>& pts, vector<Edge>& edges) {
    int n = pts.size();
    sort(pts.begin(), pts.end(), [](Point &a, Point &b){ return a.x+a.y < b.x+b.y; });
    map<long long,int> mp;
    for(int i=n-1;i>=0;i--) {
        auto it = mp.lower_bound(pts[i].y - pts[i].x);
        if(it != mp.end()) {
            int j = it->second;
            long long w = abs(pts[i].x - pts[j].x) + abs(pts[i].y - pts[j].y);
            edges.push_back({pts[i].idx, pts[j].idx, w});
        }
        mp[pts[i].y - pts[i].x] = pts[i].idx;
    }
}
int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    double eps;
    cin >> n >> eps;
    vector<pair<double,double>> input_points(n);
    for(int i=0;i<n;i++) cin >> input_points[i].first >> input_points[i].second;
    double grid_size = eps/2;
    map<pair<int,int>, int> cell;
    vector<Point> Qpts;
    vector<int> Qidx;
    for(int i=0;i<n;i++)
    {
        int gx = input_points[i].first / grid_size;
        int gy = input_points[i].second / grid_size;
        pair<int,int> c = {gx, gy};
        if(cell.count(c)==0)
        {
            cell[c] = Qpts.size();
            Qidx.push_back(i+1);
            Qpts.push_back({(int)Qpts.size(), (long long)(input_points[i].first*1e6), (long long)(input_points[i].second*1e6)});
        }
    }
    int k = Qpts.size();
    cout << k << "\n";
    for(int i=0;i<k;i++) cout << Qidx[i] << (i+1==k?"\n":" ");
    vector<Edge> edges;
    vector<Point> pts = Qpts;
    for(int s=0;s<4;s++)
    {
        for(auto &p: pts)
        {
            long long x=p.x, y=p.y;
            if(s==1) swap(p.x,p.y);
            else if(s==2) p.x=-p.x;
            else if(s==3){long long tmp=p.x; p.x=p.y; p.y=-tmp;}
        }
        add_edges(pts, edges);
        pts = Qpts;
    }
    sort(edges.begin(), edges.end());
    DSU dsu(k);
    for(auto &e: edges)
    {
        if(dsu.unite(e.u,e.v))
        {
            cout << Qidx[e.u] << " " << Qidx[e.v] << "\n";
        }
    }
    return 0;
}